/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorageFactory;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModRecipeTypes;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RecipeStorageFactory
implements IRecipeStorageFactory {
    private static final String TAG_GRID = "grid";
    private static final String BLOCK_TAG = "block";
    private static final String INPUT_TAG = "input";
    private static final String ALTOUTPUT_TAG = "alternate-output";
    private static final String SECOUTPUT_TAG = "secondary-output";
    private static final String SOURCE_TAG = "source";
    private static final String TYPE_TAG = "type";
    private static final String LOOT_TAG = "loot-table";

    @Override
    @NotNull
    public TypeToken<RecipeStorage> getFactoryOutputType() {
        return TypeConstants.RECIPE;
    }

    @Override
    @NotNull
    public TypeToken<? extends IToken<?>> getFactoryInputType() {
        return TypeConstants.ITOKEN;
    }

    @Override
    @NotNull
    public RecipeStorage getNewInstance(@NotNull IToken<?> token, @NotNull List<ItemStorage> input, int gridSize, @NotNull ItemStack primaryOutput, Block intermediate, ResourceLocation source, ResourceLocation type, List<ItemStack> altOutputs, List<ItemStack> secOutputs, ResourceLocation lootTable) {
        return new RecipeStorage(token, input, gridSize, primaryOutput, intermediate, source, type, altOutputs, secOutputs, lootTable);
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull RecipeStorage recipeStorage) {
        CompoundNBT compound = new CompoundNBT();
        ListNBT inputTagList = new ListNBT();
        for (ItemStorage itemStorage : recipeStorage.getInput()) {
            CompoundNBT neededRes = StandardFactoryController.getInstance().serialize(itemStorage);
            inputTagList.add((Object)neededRes);
        }
        compound.func_218657_a(INPUT_TAG, (INBT)inputTagList);
        recipeStorage.getPrimaryOutput().func_77955_b(compound);
        if (recipeStorage.getIntermediate() != null) {
            compound.func_218657_a(BLOCK_TAG, (INBT)NBTUtil.func_190009_a((BlockState)recipeStorage.getIntermediate().func_176223_P()));
        }
        compound.func_74768_a(TAG_GRID, recipeStorage.getGridSize());
        compound.func_218657_a("Token", (INBT)StandardFactoryController.getInstance().serialize(recipeStorage.getToken()));
        if (recipeStorage.getRecipeSource() != null) {
            compound.func_74778_a(SOURCE_TAG, recipeStorage.getRecipeSource().toString());
        }
        compound.func_74778_a(TYPE_TAG, recipeStorage.getRecipeType().getId().toString());
        ListNBT altOutputTagList = new ListNBT();
        for (ItemStack stack : recipeStorage.getAlternateOutputs()) {
            CompoundNBT neededRes = new CompoundNBT();
            stack.func_77955_b(neededRes);
            altOutputTagList.add((Object)neededRes);
        }
        compound.func_218657_a(ALTOUTPUT_TAG, (INBT)altOutputTagList);
        ListNBT listNBT = new ListNBT();
        for (ItemStack stack : recipeStorage.getCraftingToolsAndSecondaryOutputs()) {
            CompoundNBT neededRes = new CompoundNBT();
            stack.func_77955_b(neededRes);
            listNBT.add((Object)neededRes);
        }
        compound.func_218657_a(SECOUTPUT_TAG, (INBT)listNBT);
        if (recipeStorage.getLootTable() != null) {
            compound.func_74778_a(LOOT_TAG, recipeStorage.getLootTable().toString());
        }
        return compound;
    }

    @Override
    @NotNull
    public RecipeStorage deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
        ListNBT inputTagList = nbt.func_150295_c(INPUT_TAG, 10);
        for (int i = 0; i < inputTagList.size(); ++i) {
            CompoundNBT inputTag = inputTagList.func_150305_b(i);
            if (inputTag.func_74764_b("Type")) {
                input.add((ItemStorage)StandardFactoryController.getInstance().deserialize(inputTag));
                continue;
            }
            ItemStorage newItem = new ItemStorage(ItemStack.func_199557_a((CompoundNBT)inputTag));
            input.add(newItem);
        }
        ItemStack primaryOutput = ItemStack.func_199557_a((CompoundNBT)nbt);
        Block intermediate = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l(BLOCK_TAG)).func_177230_c();
        int gridSize = nbt.func_74762_e(TAG_GRID);
        IToken token = (IToken)StandardFactoryController.getInstance().deserialize(nbt.func_74775_l("Token"));
        ResourceLocation source = nbt.func_74764_b(SOURCE_TAG) ? new ResourceLocation(nbt.func_74779_i(SOURCE_TAG)) : null;
        ResourceLocation type = nbt.func_74764_b(TYPE_TAG) ? new ResourceLocation(nbt.func_74779_i(TYPE_TAG).toLowerCase()) : ModRecipeTypes.CLASSIC_ID;
        ListNBT altOutputTagList = nbt.func_150295_c(ALTOUTPUT_TAG, 10);
        ArrayList<ItemStack> altOutputs = new ArrayList<ItemStack>();
        for (int i = 0; i < altOutputTagList.size(); ++i) {
            CompoundNBT altOutputTag = altOutputTagList.func_150305_b(i);
            altOutputs.add(ItemStack.func_199557_a((CompoundNBT)altOutputTag));
        }
        ListNBT secOutputTagList = nbt.func_150295_c(SECOUTPUT_TAG, 10);
        ArrayList<ItemStack> secOutputs = new ArrayList<ItemStack>();
        for (int i = 0; i < secOutputTagList.size(); ++i) {
            CompoundNBT secOutputTag = secOutputTagList.func_150305_b(i);
            secOutputs.add(ItemStack.func_199557_a((CompoundNBT)secOutputTag));
        }
        ResourceLocation lootTable = nbt.func_74764_b(LOOT_TAG) ? new ResourceLocation(nbt.func_74779_i(LOOT_TAG)) : null;
        return this.getNewInstance(token, input, gridSize, primaryOutput, intermediate, source, type, altOutputs.isEmpty() ? null : altOutputs, secOutputs.isEmpty() ? null : secOutputs, lootTable);
    }

    @Override
    public void serialize(@NotNull IFactoryController controller, RecipeStorage input, PacketBuffer packetBuffer) {
        packetBuffer.func_150787_b(input.getInput().size());
        input.getInput().forEach(stack -> StandardFactoryController.getInstance().serialize(packetBuffer, stack));
        packetBuffer.func_150788_a(input.getPrimaryOutput());
        packetBuffer.writeBoolean(input.getIntermediate() != null);
        if (input.getIntermediate() != null) {
            packetBuffer.func_150787_b(Block.func_196246_j((BlockState)input.getIntermediate().func_176223_P()));
        }
        packetBuffer.func_150787_b(input.getGridSize());
        packetBuffer.func_192572_a(input.getRecipeType().getId());
        packetBuffer.func_150787_b(input.getAlternateOutputs().size());
        input.getAlternateOutputs().forEach(stack -> packetBuffer.func_150788_a(stack));
        packetBuffer.func_150787_b(input.getCraftingToolsAndSecondaryOutputs().size());
        input.getCraftingToolsAndSecondaryOutputs().forEach(stack -> packetBuffer.func_150788_a(stack));
        packetBuffer.writeBoolean(input.getLootTable() != null);
        if (input.getLootTable() != null) {
            packetBuffer.func_192572_a(input.getLootTable());
        }
        packetBuffer.writeBoolean(input.getRecipeSource() != null);
        if (input.getRecipeSource() != null) {
            packetBuffer.func_192572_a(input.getRecipeSource());
        }
        controller.serialize(packetBuffer, input.getToken());
    }

    @Override
    @NotNull
    public RecipeStorage deserialize(@NotNull IFactoryController controller, PacketBuffer buffer) throws Throwable {
        ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
        int inputSize = buffer.func_150792_a();
        for (int i = 0; i < inputSize; ++i) {
            input.add((ItemStorage)StandardFactoryController.getInstance().deserialize(buffer));
        }
        ItemStack primaryOutput = buffer.func_150791_c();
        Block intermediate = buffer.readBoolean() ? Block.func_196257_b((int)buffer.func_150792_a()).func_177230_c() : Blocks.field_150350_a;
        int gridSize = buffer.func_150792_a();
        ResourceLocation type = buffer.func_192575_l();
        ArrayList<ItemStack> altOutputs = new ArrayList<ItemStack>();
        int altOutputSize = buffer.func_150792_a();
        for (int i = 0; i < altOutputSize; ++i) {
            altOutputs.add(buffer.func_150791_c());
        }
        ArrayList<ItemStack> secOutputs = new ArrayList<ItemStack>();
        int secOutputSize = buffer.func_150792_a();
        for (int i = 0; i < secOutputSize; ++i) {
            secOutputs.add(buffer.func_150791_c());
        }
        ResourceLocation lootTable = null;
        if (buffer.readBoolean()) {
            lootTable = buffer.func_192575_l();
        }
        ResourceLocation source = null;
        if (buffer.readBoolean()) {
            source = buffer.func_192575_l();
        }
        IToken token = (IToken)controller.deserialize(buffer);
        return this.getNewInstance(token, input, gridSize, primaryOutput, intermediate, source, type, altOutputs.isEmpty() ? null : altOutputs, secOutputs.isEmpty() ? null : secOutputs, lootTable);
    }

    @Override
    public short getSerializationId() {
        return 26;
    }
}

